#pragma once

#include "Mushroom.h"
#include "OneUp.h"
#include "Moveables.h"
#include "ItemManager.h"

//The purpose of MoveablesManager is to create and render each moveable present in the game

class MoveablesManager
{
public:
	MoveablesManager();
	~MoveablesManager();

	void spawn(MySprite::SpriteType moveableType, sf::Vector2f spawn);	//Create a sprite, of SpriteType type at the location spawn
	void update(float dt, Mario* mario, ItemManager* itemManager);
	void deathCheck(Mario* mario);	//Check if we should kill the moveable if it is too far from Mario
	void render(sf::RenderWindow* window);

	std::vector<Moveables*> getMoveables();		//Returns the moveables vector

private:
	std::vector<Moveables*> moveables;	//moveables vector stores all the current moveables on the screen
};

